/*
 * Copyright (c) 2016, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/*
 *  Definitions & Register
 *
 */

#ifndef VPSS_H_
#define VPSS_H_

/* ------------------------------------------------------------------------ *
 *                                                                          *
 *  Variable types                                                          *
 *                                                                          *
 * ------------------------------------------------------------------------ */

#define Uint32  unsigned int
#define Uint16  unsigned short
#define Uint8   unsigned char
#define Int32   int
#define Int16   short
#define Int8    char
typedef int 	STATUS;

/* ------------------------------------------------------------------------ *
 *                                                                          *
 *  Software Breakpoint code                                                *
 *      Uses inline assembly command                                        *
 *                                                                          *
 * ------------------------------------------------------------------------ */

#define SW_BREAKPOINT    asm( " .long 0xE1200070" );

#define WR_MEM_32(addr, data)    *(unsigned int*)(addr) =(unsigned int)(data)
#define RD_MEM_32(addr) 		 *(unsigned int*)(addr)

#define HDVPSS_BASE_ADDR	0x48100000	// HDVPSS: HD Video Processing Subsystem
#define HDVPSS_END_ADDR		0x4811FFFF

#define HD_VENC_D_DVO2_BASE_ADDR		(HDVPSS_BASE_ADDR + 0xA000)	// VOUT0 module

#define DVO2_CFG0		(HD_VENC_D_DVO2_BASE_ADDR + 0x00)
#define DVO2_CFG1		(HD_VENC_D_DVO2_BASE_ADDR + 0x04)
#define DVO2_CFG2		(HD_VENC_D_DVO2_BASE_ADDR + 0x08)
#define DVO2_CFG3		(HD_VENC_D_DVO2_BASE_ADDR + 0x0C)
#define DVO2_CFG4		(HD_VENC_D_DVO2_BASE_ADDR + 0x10)
#define DVO2_CFG5		(HD_VENC_D_DVO2_BASE_ADDR + 0x14)
#define DVO2_CFG6		(HD_VENC_D_DVO2_BASE_ADDR + 0x18)
#define DVO2_CFG7		(HD_VENC_D_DVO2_BASE_ADDR + 0x1C)
#define DVO2_CFG8		(HD_VENC_D_DVO2_BASE_ADDR + 0x20)
#define DVO2_CFG9		(HD_VENC_D_DVO2_BASE_ADDR + 0x24)
#define DVO2_CFG10		(HD_VENC_D_DVO2_BASE_ADDR + 0x28)
#define DVO2_CFG11		(HD_VENC_D_DVO2_BASE_ADDR + 0x2C)
#define DVO2_CFG12		(HD_VENC_D_DVO2_BASE_ADDR + 0x30)
#define DVO2_CFG13		(HD_VENC_D_DVO2_BASE_ADDR + 0x34)
#define DVO2_CFG14		(HD_VENC_D_DVO2_BASE_ADDR + 0x38)
#define DVO2_CFG15		(HD_VENC_D_DVO2_BASE_ADDR + 0x3C)
#define DVO2_CFG16		(HD_VENC_D_DVO2_BASE_ADDR + 0x40)
#define DVO2_CFG17		(HD_VENC_D_DVO2_BASE_ADDR + 0x44)
#define DVO2_CFG18		(HD_VENC_D_DVO2_BASE_ADDR + 0x48)
#define DVO2_CFG19		(HD_VENC_D_DVO2_BASE_ADDR + 0x4C)
#define DVO2_CFG20		(HD_VENC_D_DVO2_BASE_ADDR + 0x50)
#define DVO2_CFG21		(HD_VENC_D_DVO2_BASE_ADDR + 0x54)
#define DVO2_CFG22		(HD_VENC_D_DVO2_BASE_ADDR + 0x58)
#define DVO2_CFG23		(HD_VENC_D_DVO2_BASE_ADDR + 0x5C)
#define DVO2_CFG24		(HD_VENC_D_DVO2_BASE_ADDR + 0x60)
#define DVO2_CFG25		(HD_VENC_D_DVO2_BASE_ADDR + 0x64)

/* ------------------------------------------------------------------------ *
 *  Prototypes                                                              *
 * ------------------------------------------------------------------------ */

 STATUS LCD_VPSS_Config(void);

#endif /*VPSS_H_*/

